# Exploring Java’s Set Interface: HashSet and TreeSet

The **`Set`** interface in Java represents a collection that **cannot contain duplicate elements**.
Two common implementations are:

- **`HashSet`** → stores elements in **no particular order**; offers fast insertion and lookup.
- **`TreeSet`** → stores elements in **sorted (ascending) order** according to their natural ordering or a custom comparator.

Sets are ideal when you want **uniqueness**.

---

## Code Overview

This program demonstrates how Java sets manage uniqueness and ordering:

1. **Creating Sets from Arrays**

   - The array `colors` contains several duplicates.
   - `HashSet<String>` removes duplicates automatically.

     ```java
     Set<String> colorsAsHS = new HashSet<>(Arrays.asList(colors));
     ```

     ➜ Output: colors without duplicates, order not guaranteed.

2. **Sorting with TreeSet**

   - Passing the HashSet into a `TreeSet` sorts the unique colors alphabetically.

     ```java
     TreeSet<String> colorsAsTS = new TreeSet<>(colorsAsHS);
     ```

3. **Accessing Extremes and Subsets**

   - `first()` / `last()` → smallest and largest elements.
   - `headSet("Red")` → elements _strictly smaller_ than "Red".
   - `tailSet("Red")` → elements _greater than or equal to_ "Red".
   - `lower("Red")` / `higher("Red")` → immediate neighbors before/after "Red".

